/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.access.api.AcaClient;
import com.ibm.hsc.access.api.AcaRole;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.common.util.AccUtils;
import com.ibm.websm.diagnostics.IDebug;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class AccCreateCfg {
    private String m_target = null;
    private String m_file = null;
    private String m_rsrcs = null;
    public AcaClient m_acaCl = null;
    private HashMap m_validParams = new HashMap();
    private Vector m_input;

    public AccCreateCfg() {
        this.m_validParams.put("-f", null);
        this.m_validParams.put("-t", null);
        this.m_validParams.put("-i", null);
    }

    protected void getMissingParamMsg(String string) throws PIHscClientException, RequiredParameterException {
        String[] stringArray = new String[]{string};
        AccUtils.throwRequiredParam(stringArray);
    }

    private void doCreateRole() throws PIHscClientException, RequiredParameterException {
        AcaRole acaRole;
        AcaRole acaRole2;
        Object object;
        AccUtils.DBG("doChangeRole=" + (String)this.m_input.get(0));
        String string = AccUtils.parseStrData(AccUtils.NAME_TAG, (String)this.m_input.get(0));
        if (string.length() <= 0) {
            object = new String[]{AccUtils.RESOURCE_TAG + AccUtils.NAME_TAG};
            AccUtils.throwRequiredParam((String[])object);
        }
        if (((String)(object = AccUtils.parseStrData(AccUtils.PARENT_TAG, (String)this.m_input.get(0)))).length() <= 0) {
            acaRole2 = new AcaRole[]{AccUtils.RESOURCE_TAG + AccUtils.PARENT_TAG};
            AccUtils.throwRequiredParam((String[])acaRole2);
        }
        if ((acaRole2 = this.m_acaCl.GetRoleProperty((String)object)) == null) {
            AccUtils.throwInvalidParm(AccUtils.PARENT_TAG + (String)object);
        }
        if ((acaRole = AccUtils.parseRoleData(acaRole2, (String)this.m_input.get(0), AccUtils.RESOURCE_TAG)) == null) {
            AccUtils.DBG("Unknown resources for the role " + string);
            String[] stringArray = new String[]{AccUtils.RESOURCE_TAG};
            AccUtils.throwRequiredParam(stringArray);
        }
        acaRole.dump();
        int n = this.m_acaCl.CreateRole(acaRole);
        if (n != 0) {
            AccUtils.DBG("Return code=" + n);
            String string2 = AcaClient.GetMessage((int)n);
            AccUtils.SHOW(string2);
            System.exit(AccUtils.FAILURE);
        }
    }

    private void doCreateGroup() throws PIHscClientException, RequiredParameterException {
        String[] stringArray;
        AccUtils.DBG("doChangeGroup=" + (String)this.m_input.get(0));
        int n = 0;
        String string = (String)this.m_input.get(0);
        String string2 = AccUtils.parseStrData(AccUtils.NAME_TAG, string);
        if (string2.length() <= 0) {
            stringArray = new String[]{AccUtils.NAME_TAG};
            AccUtils.throwRequiredParam(stringArray);
        }
        if (string.indexOf(AccUtils.RESOURCE_TAG) < 0) {
            stringArray = new String[]{AccUtils.RESOURCE_TAG};
            AccUtils.throwRequiredParam(stringArray);
        }
        String string3 = "hmcsuperadmin";
        AccUtils.DBG("name=" + string2 + " role=" + string3);
        stringArray = this.m_acaCl.GetRoleProperty(string3);
        Vector vector = AccUtils.parseGroupDataForCreate(AccUtils.RESOURCE_TAG, string, (AcaRole)stringArray);
        vector.trimToSize();
        AccUtils.DBG("Create Group");
        n = this.m_acaCl.CreateGroup(string2, vector.toArray(new String[0]));
        if (n != 0) {
            AccUtils.DBG("Return code=" + n);
            String string4 = AcaClient.GetMessage((int)n);
            AccUtils.SHOW(string4);
            System.exit(AccUtils.FAILURE);
        }
    }

    public void performCommand() throws PIHscClientException, RequiredParameterException {
        AccUtils.DBG("In performCommand");
        Hashtable hashtable = new Hashtable();
        Object var2_2 = null;
        if (this.m_target.equals("taskrole")) {
            this.doCreateRole();
        } else if (this.m_target.equals("resourcerole")) {
            this.doCreateGroup();
        }
        AccUtils.DBG("Out AccCreateCfg::m_input values = " + this.m_input);
    }

    public void mapParameters(HashMap hashMap) throws PIHscClientException, RequiredParameterException {
        String[] stringArray;
        AccUtils.DBG("In mapParameters");
        this.m_target = (String)hashMap.get("-t");
        if (this.m_target == null || !this.m_target.equals("taskrole") && !this.m_target.equals("resourcerole")) {
            stringArray = new String[]{"-t"};
            AccUtils.throwRequiredParam(stringArray);
        }
        this.m_target = this.m_target.trim();
        this.m_input = new Vector();
        this.m_file = (String)hashMap.get("-f");
        if (this.m_file != null) {
            this.m_file = (String)hashMap.get(HMCCommandUtils.FILE_PARAM);
            if (this.m_file == null) {
                stringArray = new String[]{this.m_file};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "FILE_NOT_FOUND", stringArray, null);
            }
            try {
                this.m_input = PIHMCCommandUtils.readInputFile(this.m_file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String[] stringArray2 = new String[]{this.m_file};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "FILE_NOT_FOUND", stringArray2, null);
            }
            catch (IOException iOException) {
                AccUtils.DBG("exception 2");
                String[] stringArray3 = new String[]{this.m_file};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "IO_EXCEPTION", stringArray3, null);
            }
            AccUtils.DBG(this.m_input.toString());
        } else {
            this.m_rsrcs = (String)hashMap.get("-i");
            if (this.m_rsrcs == null || this.m_rsrcs.length() <= 0) {
                this.getMissingParamMsg("-i | -f");
            }
            this.m_input.add(this.m_rsrcs);
        }
        AccUtils.DBG("cmdParameter=" + hashMap);
    }

    public void printHelp() {
        String string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "ACCCREATECFG_HELP");
        AccUtils.SHOW(string);
    }

    public static void main(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        try {
            String string2 = null;
            AccCreateCfg accCreateCfg = new AccCreateCfg();
            if (stringArray.length == 0) {
                accCreateCfg.printHelp();
            } else {
                boolean bl = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = stringArray[i];
                    arrayList.add(string2);
                    if (!string2.equals("--help")) continue;
                    accCreateCfg.printHelp();
                    bl = true;
                    break;
                }
                if (!bl) {
                    HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, accCreateCfg.m_validParams);
                    accCreateCfg.mapParameters(hashMap);
                    accCreateCfg.m_acaCl = new AcaClient(1);
                    accCreateCfg.performCommand();
                }
            }
        }
        catch (PIHscClientException pIHscClientException) {
            if (IDebug.enabled()) {
                pIHscClientException.printStackTrace();
            }
            if ((string = pIHscClientException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "COMMAND_LINE_ERROR");
            }
            AccUtils.SHOW(string);
            System.exit(AccUtils.FAILURE);
        }
        catch (Throwable throwable) {
            if (IDebug.enabled()) {
                throwable.printStackTrace();
            }
            if ((string = throwable.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "COMMAND_LINE_ERROR");
            }
            AccUtils.SHOW(string);
            System.exit(AccUtils.FAILURE);
        }
        System.exit(AccUtils.SUCCESS);
    }
}

